﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private EvaluationSheetBL _EvaluationSheetBL = null;

        public EvaluationSheetBL EvaluationSheet
        {
            get
            {
                if (_EvaluationSheetBL == null)
                {
                    _EvaluationSheetBL = new EvaluationSheetBL(this);
                }

                return _EvaluationSheetBL;
            }
        }

        public class EvaluationSheetBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
        {
            public EvaluationSheetBL(ZSBELearning BL) : base(BL) { }

            public List<BO.EvaluationSheet> Restore()
            {
                return BLP.DAL.EvaluationSheet.Restore();
            }



            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.EvaluationSheet.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Save(BO.EvaluationSheet EvaluationSheet)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    if (EvaluationSheet == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                        if (EvaluationSheet.ID.HasValue)
                            {
                                _methodResult.SetSuccess = BLP.DAL.EvaluationSheet.Update(EvaluationSheet);
                            }
                            else
                            {
                                _methodResult.SetSuccess = BLP.DAL.EvaluationSheet.Create(EvaluationSheet);                                
                            }
                    }
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Exception.Value, _exception);
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.EvaluationSheet EvaluationSheet)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (EvaluationSheet != null)
                {
                    try
                    {
                        _methodResult.SetSuccess = BLP.DAL.EvaluationSheet.Remove(EvaluationSheet);

                        if (!_methodResult.Success)
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                        }
                    }
                    catch (Exception _exception)
                    {
                        _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                    }
                }
                return _methodResult;
            }

            public BO.EvaluationSheet New()
            {
                return BLP.DAL.EvaluationSheet.New();
            }

            public int Count()
            {
                return BLP.DAL.EvaluationSheet.Count();
            }

            public int Count(BO.School School)
            {
                ELearning.BL.BO.Class.Search _search = new BO.Class.Search();
                _search.SchoolID = School.ID;
                return BLP.DAL.Class.Count(_search);
            }

            private ViewBL _view = null;

            public ViewBL View
            {
                get
                {
                    if (_view == null)
                    {
                        _view = new ViewBL(this.BLP);
                    }
                    return _view;
                }
            }

            public class ViewBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public ViewBL(ZSBELearning BL) : base(BL) { }

                public List<BO.View.EvaluationSheet> Restore(BO.Class Class)
                {
                    BO.View.EvaluationSheet.Search _search = new BO.View.EvaluationSheet.Search();
                    _search.ClassID = Class.ID;

                    return BLP.DAL.EvaluationSheetView.Restore(_search);
                }

                public BO.View.EvaluationSheet Restore(BO.Student Student, int Point, int MaxPoint)
                {
                    BO.View.EvaluationSheet.Search _search = new BO.View.EvaluationSheet.Search();
                    _search.ClassID = Student.ClassID;
                    _search.PointPercent = BLP.Utility.PointPercent(Point, MaxPoint);

                    return BLP.DAL.EvaluationSheetView.RestoreTopOne(_search);
                }

                public BO.View.EvaluationSheet Restore(BO.Class Class, int Point, int MaxPoint)
                {
                    BO.View.EvaluationSheet.Search _search = new BO.View.EvaluationSheet.Search();
                    _search.ClassID = Class.ID;
                    _search.PointPercent = BLP.Utility.PointPercent(Point, MaxPoint);

                    return BLP.DAL.EvaluationSheetView.RestoreTopOne(_search);
                }
            }

            private ClassBL _ClassBL = null;

            public ClassBL Class
            {
                get
                {
                    if (_ClassBL == null)
                    {
                        _ClassBL = new ClassBL(this.BLP);
                    }
                    return _ClassBL;
                }
            }

            public class ClassBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public BO.EvaluationSheet_Class New()
                {
                    return BLP.DAL.EvaluationSheet_Class.New();
                }

                public ClassBL(ZSBELearning BL) : base(BL) { }

                public List<BO.EvaluationSheet_Class> Restore(BO.Class Class)
                {
                    BO.EvaluationSheet_Class.Search _search = new BO.EvaluationSheet_Class.Search();
                    _search.ClassID = Class.ID;

                    return BLP.DAL.EvaluationSheet_Class.Restore(_search);
                }

                public Gemini.Core.BL.Base.MethodResult Save(BO.EvaluationSheet_Class EvaluationSheet_Class)
                {
                    Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                    try
                    {
                        if (EvaluationSheet_Class == null)
                        {
                            _methodResult.SetSuccess = false;
                        }
                        else
                        {
                            if (EvaluationSheet_Class.ID.HasValue)
                            {
                                _methodResult.SetSuccess = BLP.DAL.EvaluationSheet_Class.Update(EvaluationSheet_Class);
                            }
                            else
                            {
                                _methodResult.SetSuccess = BLP.DAL.EvaluationSheet_Class.Create(EvaluationSheet_Class);
                            }
                        }
                    }
                    catch (Exception _exception)
                    {
                        _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Exception.Value, _exception);
                    }
                    return _methodResult;
                }

                public Gemini.Core.BL.Base.MethodResult Remove(BO.EvaluationSheet_Class EvaluationSheet_Class)
                {
                    Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                    if (EvaluationSheet_Class != null)
                    {
                        try
                        {
                            _methodResult.SetSuccess = BLP.DAL.EvaluationSheet_Class.Remove(EvaluationSheet_Class);

                            if (!_methodResult.Success)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                            }
                        }
                        catch (Exception _exception)
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                        }
                    }
                    return _methodResult;
                }

                public Gemini.Core.BL.Base.MethodResult Remove(BO.Class Class)
                {
                    Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                    if (Class != null)
                    {
                        try
                        {
                            BO.EvaluationSheet_Class.Search _search = new BO.EvaluationSheet_Class.Search();
                            _search.ClassID = Class.ID;

                            _methodResult.SetSuccess = BLP.DAL.EvaluationSheet_Class.Remove(_search);

                            if (!_methodResult.Success)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                            }
                        }
                        catch (Exception _exception)
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                        }
                    }
                    return _methodResult;
                }

                public Gemini.Core.BL.Base.MethodResult Create(BO.Class Class)
                {
                    Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                    if (Class != null)
                    {
                        try
                        {
                            List<BO.EvaluationSheet> _listEvaluationSheet = BLP.EvaluationSheet.Restore();
                            foreach (BO.EvaluationSheet _loopEvaluationSheet in _listEvaluationSheet)
                            {
                                BO.EvaluationSheet_Class _evaluationSheet_Class = New();
                                
                                _evaluationSheet_Class.ClassID = Class.ID;
                                _evaluationSheet_Class.From = _loopEvaluationSheet.From;
                                _evaluationSheet_Class.To = _loopEvaluationSheet.To;
                                _evaluationSheet_Class.EvaluationSheetID = _loopEvaluationSheet.ID;

                                _methodResult.Add(Save(_evaluationSheet_Class));
                            }

                            if (!_methodResult.Success)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Failed.Value, false);
                            }
                        }
                        catch (Exception _exception)
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.SaveEvents.Exception.Value, _exception);
                        }
                    }
                    return _methodResult;
                }
            }

            private CacheBL _CacheBL = null;

            public CacheBL Cache
            {
                get
                {
                    if (_CacheBL == null)
                    {
                        _CacheBL = new CacheBL(this.BLP);
                    }
                    return _CacheBL;
                }
            }

            public class CacheBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                private Dictionary<long, BO.EvaluationSheet> _cacheDictionary = null;

                protected Dictionary<long, BO.EvaluationSheet> CacheDictionary
                {
                    get
                    {
                        if (_cacheDictionary == null)
                        {
                            _cacheDictionary = new Dictionary<long, BO.EvaluationSheet>();

                            List<BO.EvaluationSheet> _listEvaluationSheet = BLP.EvaluationSheet.Restore();

                            foreach (BO.EvaluationSheet _loopEvaluationSheet in _listEvaluationSheet)
                            {
                                _cacheDictionary.Add(_loopEvaluationSheet.ID.Value, _loopEvaluationSheet);
                            }
                        }

                        return _cacheDictionary;
                    }
                }

                public CacheBL(ZSBELearning BL) : base(BL) { }

                public BO.EvaluationSheet Restore(long? ID)
                {
                    BO.EvaluationSheet _EvaluationSheet = null;
                    if (ID.HasValue)
                    {
                        _EvaluationSheet = CacheDictionary[ID.Value];
                    }
                    return _EvaluationSheet;
                }

                public string RestoreName(long? ID)
                {
                    string _name = string.Empty;

                    BO.EvaluationSheet _EvaluationSheet = Restore(ID);

                    if (_EvaluationSheet != null)
                    {
                        _name = _EvaluationSheet.Name;
                    }

                    return _name;
                }

                public string RestoreAbbreviation(long? ID)
                {
                    string _Abbreviation = string.Empty;

                    BO.EvaluationSheet _EvaluationSheet = Restore(ID);

                    if (_EvaluationSheet != null)
                    {
                        _Abbreviation = _EvaluationSheet.Abbreviation;
                    }

                    return _Abbreviation;
                }
            }

            public BO.EvaluationSheet Restore(long? ID)
            {
                BO.EvaluationSheet _EvaluationSheet = null;
                
                if (ID.HasValue)
                {
                    _EvaluationSheet = BLP.DAL.EvaluationSheet.Restore(ID);
                }

                return _EvaluationSheet;
            }

            public Gemini.Core.BL.Interface.BO.IBaseUnique<long?> RestoreByID(long? ID)
            {
                return Restore(ID);
            }

            public BO.EvaluationSheet Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                BO.EvaluationSheet _EvaluationSheet = null;

                if (BO != null)
                {
                    _EvaluationSheet = BLP.DAL.EvaluationSheet.Restore(BO.ID);
                }

                return _EvaluationSheet;
            }

            public BO.EvaluationSheet RestoreByWeight(int Weight)
            {
                BO.EvaluationSheet.Search _Search = new BO.EvaluationSheet.Search();
                _Search.Weight = Weight;

                return BLP.DAL.EvaluationSheet.RestoreTopOne(_Search);
            }
        }
    }
}